<div class="block-content block-content-no-pad row mb-4">
    <div class="col-12 col-sm-12 col-md-3 mb-5 app-image text-center">
        <img src="<?php echo e($app->app_image_url); ?>" alt="<?php echo e($app->title); ?>"
            style="padding: 5px;background: #f7f7f7;border-radius: 10px;width:170px;">
    </div>
    <div class="col-12 col-sm-12 col-md-9 mb-5 mt-1" style="padding: 0 25px;">
        <div>
            <h2><?php echo e($app->title); ?></h2>
        </div>

        <?php if(isset($latest_version) && $latest_version != ''): ?>
            <div>
                <span itemprop="version"><span class="text-success"><?php echo e($latest_version); ?></span> <?php echo e(__('dcm.for_android')); ?></span>
            </div>
        <?php endif; ?>
        <div>
            <div class="rating" itemprop="aggregateRating" itemscope="" itemtype="http://schema.org/AggregateRating">
                <div class="stars-detail">
                <span class="score" title="<?php echo e(__('dcm.app_average_rating',['attr' => $app->title, 'rating' => $app->current_ratings ])); ?>" style="width: <?php echo e(ceil(((double) $app->current_ratings / 5) * 100)); ?>%;"></span>
                </div>
                <meta itemprop="ratingCount" content="<?php echo e($app->current_ratings); ?>">
                <meta itemprop="bestRating" content="5">
                <meta itemprop="worstRating" content="1">
            </div>
            <span class="star average" itemprop="ratingValue"><?php echo e($app->current_ratings); ?></span>
                <span class="details-delimiter"> | </span>
                <a href="#comment" class="details-to-bottom" data-type="reviews"><?php echo e(__('dcm.total_reviews', ['attr' => 0])); ?></a>
                <span class="details-delimiter"> | </span>
            <a href="#comment" class="details-to-bottom" data-type="posts"><?php echo e(__('dcm.total_comments', ['attr' => $app->comments->count()])); ?></a>
        </div>

        <?php if(isset($app->developer) && $app->developer->count() > 0): ?>
            <div>
                <p itemprop="publisher">
                    <?php echo e(__('dcm.by_developer')); ?>

                    <?php $__currentLoopData = $app->developer; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $developer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a title="<?php echo e(__('dcm.developer_title_tag', ['attr' => $developer->title ])); ?>" href="<?php echo e($developer->developer_detail_url); ?>">
                            <?php echo e($developer->title); ?>

                        </a> <?php if(!$loop->last): ?> | <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </p>
            </div>
        <?php endif; ?>


        <div class="mt-3">
                <div class="btn-group mr-2 mb-2" role="group" aria-label="Icons File group">
                <a href="<?php echo e($app->app_download_url); ?>" class="btn btn-hero-lg btn-square btn-hero-primary mr-1 mb-3">
                    <i class="fa fa-fw fa-download mr-1"></i> <?php echo e(__('dcm.download_apk_title')); ?>

                    <?php if(isset($latest_version_size) && $latest_version_size > 0): ?> <small> ( <?php echo e($latest_version_size); ?> )</small> <?php endif; ?>
                </a>
                <button type="button" class="btn btn-hero btn-square btn-light mr-1 mb-3">
                    <a class="btn" style="box-shadow: 0 0 0 0 transparent;" href="<?php echo e(route('web.app.detail.versions', $app->slug)); ?>"><i class="fa fa-fw fa-sort-numeric-up mr-1"></i> Versions</a>
                </button>
                </div>

        </div>

    </div>
</div>